//=============================================================================
// SuperHealth.
//=============================================================================
class Health_SuperHealth extends SuperHealth;

var int HealUpTo;

auto state Pickup
{	
	function Touch( actor Other )
	{
	local Pawn P;
			
	if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
		{	
		P = Pawn(Other);	
		if (P.Health < HealUpTo) 
			{
			P.Health += HealingAmount;
			if (P.Health > HealUpTo)
				{
				P.Health = HealUpTo;
				}
			PlayPickupMessage(P);
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();
			}
		}
	}
}

defaultproperties
{
     HealUpTo=500
     HealingAmount=100
     PickupMessage="You picked up the Super Health Pack"
     RespawnTime=0.000000
     PickupViewMesh=LodMesh'UnrealShare.SuperHealthMesh'
     MaxDesireability=1.000000
     Texture=None
     Mesh=LodMesh'UnrealShare.SuperHealthMesh'
     CollisionRadius=16.000000
     CollisionHeight=19.500000
     MultiSkins(0)=Texture'UnrealShare.Belt_fx.ShieldBelt.RedShield'
     MultiSkins(1)=Texture'UnrealShare.Belt_fx.ShieldBelt.BlueShield'
}
